//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2

import wesual.Ui 1.0

Rectangle {
    id : progressBar

    property int  barMargin : 1
    property real value : 0.0

    implicitWidth : 100
    implicitHeight : 20

    color : UiColors.getColor(UiColors.ProgressbarBGGrey)

    Rectangle {
        anchors {
            top     : parent.top
            bottom  : parent.bottom
            left    : parent.left
            margins : progressBar.barMargin
        }
        width : progressBar.value *
                (progressBar.width - progressBar.barMargin * 2)
        color : UiColors.getColor(UiColors.ButtonNormalBlue)
    }
}
